/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.usage.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.usage.IAnalyticsEventHandler;
import com.aptana.usage.UsagePlugin;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticsHandlersManager {
    private static final String EXTENSION_POINT_ID = "analyticsHandlers";
    private static final String ELEMENT_HANDLER = "eventHandler";
    private static final String CLASS = "class";
    private static AnalyticsHandlersManager instance;
    private Set<IAnalyticsEventHandler> handlers;

    public static synchronized AnalyticsHandlersManager getInstance() {
        if (instance == null) {
            instance = new AnalyticsHandlersManager();
        }
        return instance;
    }

    private AnalyticsHandlersManager() {
        this.loadExtensions();
    }

    public Set<IAnalyticsEventHandler> getHandlers() {
        return this.handlers;
    }

    private void loadExtensions() {
        final HashSet eventHandlers = new HashSet();
        EclipseUtil.processConfigurationElements((String)"com.aptana.usage", (String)EXTENSION_POINT_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                String name = element.getName();
                if (AnalyticsHandlersManager.ELEMENT_HANDLER.equals(name)) {
                    try {
                        eventHandlers.add((IAnalyticsEventHandler)element.createExecutableExtension(AnalyticsHandlersManager.CLASS));
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)UsagePlugin.getDefault(), (String)"Error loading an analytics handler", (Throwable)e);
                    }
                }
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newSet((Object[])new String[]{AnalyticsHandlersManager.ELEMENT_HANDLER});
            }
        });
        this.handlers = Collections.unmodifiableSet(eventHandlers);
    }
}

